/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.HashSet;
import java.util.Set;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.bytes.IBuffer;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.PageActions;
import org.pdfclown.documents.PageAnnotations;
import org.pdfclown.documents.PageArticleElements;
import org.pdfclown.documents.contents.ContentScanner;
import org.pdfclown.documents.contents.Contents;
import org.pdfclown.documents.contents.IContentContext;
import org.pdfclown.documents.contents.Resources;
import org.pdfclown.documents.contents.RotationEnum;
import org.pdfclown.documents.contents.composition.PrimitiveComposer;
import org.pdfclown.documents.contents.objects.ContentObject;
import org.pdfclown.documents.contents.xObjects.FormXObject;
import org.pdfclown.documents.contents.xObjects.XObject;
import org.pdfclown.documents.interaction.navigation.page.Transition;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfReal;
import org.pdfclown.objects.PdfReference;
import org.pdfclown.objects.PdfStream;
import org.pdfclown.objects.Rectangle;
import org.pdfclown.util.NotImplementedException;
import org.pdfclown.util.math.geom.Dimension;

@PDF(value=VersionEnum.PDF10)
public final class Page
extends PdfObjectWrapper<PdfDictionary>
implements IContentContext,
Printable {
    public static final Set<PdfName> InheritableAttributeKeys = new HashSet<PdfName>();

    static {
        InheritableAttributeKeys.add(PdfName.Resources);
        InheritableAttributeKeys.add(PdfName.MediaBox);
        InheritableAttributeKeys.add(PdfName.CropBox);
        InheritableAttributeKeys.add(PdfName.Rotate);
    }

    public static PdfDirectObject getInheritableAttribute(PdfDictionary pageObject, PdfName key) {
        PdfDictionary dictionary = pageObject;
        do {
            PdfDirectObject entry;
            if ((entry = dictionary.get(key)) == null) continue;
            return entry;
        } while ((dictionary = (PdfDictionary)dictionary.resolve(PdfName.Parent)) != null);
        if (pageObject.get(PdfName.Parent) == null) {
            throw new RuntimeException("Inheritable attributes unreachable: Page objects MUST be inserted into their document's Pages collection before being used.");
        }
        return null;
    }

    public static Page wrap(PdfDirectObject baseObject) {
        return baseObject == null ? null : new Page(baseObject);
    }

    public Page(Document context) {
        this(context, null);
    }

    public Page(Document context, Dimension2D size) {
        super(context, new PdfDictionary(new PdfName[]{PdfName.Type, PdfName.Contents}, new PdfDirectObject[]{PdfName.Page, context.getFile().register(new PdfStream())}));
        if (size != null) {
            this.setSize(size);
        }
    }

    private Page(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public Page clone(Document context) {
        return (Page)super.clone(context);
    }

    @PDF(value=VersionEnum.PDF12)
    public PageActions getActions() {
        return new PageActions(((PdfDictionary)this.getBaseDataObject()).get(PdfName.AA, PdfDictionary.class));
    }

    public PageAnnotations getAnnotations() {
        return new PageAnnotations(((PdfDictionary)this.getBaseDataObject()).get(PdfName.Annots, PdfArray.class), this);
    }

    @PDF(value=VersionEnum.PDF13)
    public Rectangle2D getArtBox() {
        PdfDirectObject artBoxObject = this.getInheritableAttribute(PdfName.ArtBox);
        return artBoxObject != null ? Rectangle.wrap(artBoxObject).toRectangle2D() : this.getCropBox();
    }

    public PageArticleElements getArticleElements() {
        return new PageArticleElements(((PdfDictionary)this.getBaseDataObject()).get(PdfName.B, PdfArray.class), this);
    }

    @PDF(value=VersionEnum.PDF13)
    public Rectangle2D getBleedBox() {
        PdfDirectObject bleedBoxObject = this.getInheritableAttribute(PdfName.BleedBox);
        return bleedBoxObject != null ? Rectangle.wrap(bleedBoxObject).toRectangle2D() : this.getCropBox();
    }

    public Rectangle2D getCropBox() {
        PdfDirectObject cropBoxObject = this.getInheritableAttribute(PdfName.CropBox);
        return cropBoxObject != null ? Rectangle.wrap(cropBoxObject).toRectangle2D() : this.getBox();
    }

    @PDF(value=VersionEnum.PDF11)
    public double getDuration() {
        PdfNumber durationObject = (PdfNumber)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Dur);
        return durationObject == null ? 0.0 : durationObject.getDoubleValue();
    }

    public int getIndex() {
        PdfReference ancestorKidReference = (PdfReference)this.getBaseObject();
        PdfReference parentReference = (PdfReference)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Parent);
        PdfDictionary parent = (PdfDictionary)parentReference.getDataObject();
        PdfArray kids = (PdfArray)parent.resolve(PdfName.Kids);
        int index = 0;
        int i = 0;
        while (true) {
            PdfReference kidReference;
            if ((kidReference = (PdfReference)kids.get(i)).equals(ancestorKidReference)) {
                if (!parent.containsKey(PdfName.Parent)) {
                    return index;
                }
                ancestorKidReference = parentReference;
                parentReference = (PdfReference)parent.get(PdfName.Parent);
                parent = (PdfDictionary)parentReference.getDataObject();
                kids = (PdfArray)parent.resolve(PdfName.Kids);
                i = -1;
            } else {
                PdfDictionary kid = (PdfDictionary)kidReference.getDataObject();
                index = kid.get(PdfName.Type).equals(PdfName.Page) ? ++index : (index += ((Integer)((PdfInteger)kid.get(PdfName.Count)).getRawValue()).intValue());
            }
            ++i;
        }
    }

    public Dimension2D getSize() {
        return Dimension.get(this.getBox());
    }

    @PDF(value=VersionEnum.PDF15)
    public TabOrderEnum getTabOrder() {
        return TabOrderEnum.get((PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Tabs));
    }

    @PDF(value=VersionEnum.PDF11)
    public Transition getTransition() {
        return Transition.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.Trans));
    }

    @PDF(value=VersionEnum.PDF13)
    public Rectangle2D getTrimBox() {
        PdfDirectObject trimBoxObject = this.getInheritableAttribute(PdfName.TrimBox);
        return trimBoxObject != null ? Rectangle.wrap(trimBoxObject).toRectangle2D() : this.getCropBox();
    }

    public void setActions(PageActions value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.AA, value.getBaseObject());
    }

    public void setAnnotations(PageAnnotations value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Annots, value.getBaseObject());
    }

    public void setArtBox(Rectangle2D value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.ArtBox, (PdfDirectObject)new Rectangle(value).getBaseDataObject());
    }

    public void setBleedBox(Rectangle2D value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.BleedBox, (PdfDirectObject)new Rectangle(value).getBaseDataObject());
    }

    public void setBox(Rectangle2D value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.MediaBox, (PdfDirectObject)new Rectangle(value).getBaseDataObject());
    }

    public void setCropBox(Rectangle2D value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.CropBox, (PdfDirectObject)new Rectangle(value).getBaseDataObject());
    }

    public void setDuration(double value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Dur, value == 0.0 ? null : PdfReal.get(value));
    }

    public void setRotation(RotationEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Rotate, value.getCode());
    }

    public void setSize(Dimension2D value) {
        Rectangle2D box;
        try {
            box = this.getBox();
        }
        catch (Exception e) {
            box = new Rectangle2D.Double();
        }
        box.setRect(box.getX(), box.getY(), value.getWidth(), value.getHeight());
        this.setBox(box);
    }

    public void setTabOrder(TabOrderEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Tabs, value.getCode());
    }

    public void setTransition(Transition value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Trans, value.getBaseObject());
    }

    public void setTrimBox(Rectangle2D value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.TrimBox, (PdfDirectObject)new Rectangle(value).getBaseDataObject());
    }

    @Override
    public Rectangle2D getBox() {
        return Rectangle.wrap(this.getInheritableAttribute(PdfName.MediaBox)).toRectangle2D();
    }

    @Override
    public Contents getContents() {
        PdfDirectObject contentsObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.Contents);
        if (contentsObject == null) {
            contentsObject = this.getFile().register(new PdfStream());
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Contents, contentsObject);
        }
        return Contents.wrap(contentsObject, this);
    }

    @Override
    public Resources getResources() {
        Resources resources = Resources.wrap(this.getInheritableAttribute(PdfName.Resources));
        return resources != null ? resources : Resources.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.Resources, PdfDictionary.class));
    }

    @Override
    public RotationEnum getRotation() {
        return RotationEnum.valueOf((PdfInteger)this.getInheritableAttribute(PdfName.Rotate));
    }

    @Override
    public void render(Graphics2D context, Dimension2D size) {
        ContentScanner scanner = new ContentScanner(this.getContents());
        scanner.render(context, size);
    }

    @Override
    public ContentObject toInlineObject(PrimitiveComposer composer) {
        throw new NotImplementedException();
    }

    @Override
    public XObject toXObject(Document context) {
        FormXObject form = new FormXObject(context, this.getBox());
        form.setResources(context.equals(this.getDocument()) ? this.getResources() : this.getResources().clone(context));
        IBuffer formBody = ((PdfStream)form.getBaseDataObject()).getBody();
        PdfDataObject contentsDataObject = ((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.Contents);
        if (contentsDataObject instanceof PdfStream) {
            formBody.append(((PdfStream)contentsDataObject).getBody());
        } else {
            for (PdfDirectObject contentStreamObject : (PdfArray)contentsDataObject) {
                formBody.append(((PdfStream)contentStreamObject.resolve()).getBody());
            }
        }
        return form;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        this.render((Graphics2D)graphics, new Dimension(pageFormat.getWidth(), pageFormat.getHeight()));
        return 0;
    }

    private PdfDirectObject getInheritableAttribute(PdfName key) {
        return Page.getInheritableAttribute((PdfDictionary)this.getBaseDataObject(), key);
    }

    @PDF(value=VersionEnum.PDF15)
    public static enum TabOrderEnum {
        Row(PdfName.R),
        Column(PdfName.C),
        Structure(PdfName.S);

        private final PdfName code;

        public static TabOrderEnum get(PdfName value) {
            TabOrderEnum[] tabOrderEnumArray = TabOrderEnum.values();
            int n = tabOrderEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                TabOrderEnum tabOrder = tabOrderEnumArray[n2];
                if (tabOrder.getCode().equals(value)) {
                    return tabOrder;
                }
                ++n2;
            }
            return null;
        }

        private TabOrderEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }
}

