/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents;

import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.interaction.actions.Action;
import org.pdfclown.documents.interaction.navigation.document.Destination;
import org.pdfclown.documents.interaction.navigation.document.LocalDestination;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;

@PDF(value=VersionEnum.PDF14)
public final class DocumentActions
extends PdfObjectWrapper<PdfDictionary> {
    public DocumentActions(Document context) {
        super(context, new PdfDictionary());
    }

    DocumentActions(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public DocumentActions clone(Document context) {
        return (DocumentActions)super.clone(context);
    }

    public Action getAfterPrint() {
        return Action.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.DP));
    }

    public Action getAfterSave() {
        return Action.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.DS));
    }

    public Action getBeforePrint() {
        return Action.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.WP));
    }

    public Action getBeforeSave() {
        return Action.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.WS));
    }

    public Action getOnClose() {
        return Action.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.DC));
    }

    public PdfObjectWrapper<?> getOnOpen() {
        PdfDirectObject onOpenObject = ((PdfDictionary)this.getDocument().getBaseDataObject()).get(PdfName.OpenAction);
        if (onOpenObject instanceof PdfDictionary) {
            return Action.wrap(onOpenObject);
        }
        return Destination.wrap(onOpenObject);
    }

    public void setAfterPrint(Action value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.DP, value.getBaseObject());
    }

    public void setAfterSave(Action value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.DS, value.getBaseObject());
    }

    public void setBeforePrint(Action value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.WP, value.getBaseObject());
    }

    public void setBeforeSave(Action value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.WS, value.getBaseObject());
    }

    public void setOnClose(Action value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.DC, value.getBaseObject());
    }

    public void setOnOpen(PdfObjectWrapper<?> value) {
        if (!(value instanceof Action) && !(value instanceof LocalDestination)) {
            throw new IllegalArgumentException("Value MUST be either an Action or a LocalDestination.");
        }
        ((PdfDictionary)this.getDocument().getBaseDataObject()).put(PdfName.OpenAction, value.getBaseObject());
    }
}

