/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.bytes.filters;

import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.bytes.filters.ASCII85Filter;
import org.pdfclown.bytes.filters.FlateFilter;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfName;
import org.pdfclown.util.NotImplementedException;

@PDF(value=VersionEnum.PDF10)
public abstract class Filter {
    private static final Filter ASCII85Filter = new ASCII85Filter();
    private static final Filter FlateDecode = new FlateFilter();

    public static Filter get(PdfName name) {
        if (name == null) {
            return null;
        }
        if (name.equals(PdfName.FlateDecode) || name.equals(PdfName.Fl)) {
            return FlateDecode;
        }
        if (name.equals(PdfName.LZWDecode) || name.equals(PdfName.LZW)) {
            throw new NotImplementedException("LZWDecode");
        }
        if (name.equals(PdfName.ASCIIHexDecode) || name.equals(PdfName.AHx)) {
            throw new NotImplementedException("ASCIIHexDecode");
        }
        if (name.equals(PdfName.ASCII85Decode) || name.equals(PdfName.A85)) {
            return ASCII85Filter;
        }
        if (name.equals(PdfName.RunLengthDecode) || name.equals(PdfName.RL)) {
            throw new NotImplementedException("RunLengthDecode");
        }
        if (name.equals(PdfName.CCITTFaxDecode) || name.equals(PdfName.CCF)) {
            throw new NotImplementedException("CCITTFaxDecode");
        }
        if (name.equals(PdfName.JBIG2Decode)) {
            throw new NotImplementedException("JBIG2Decode");
        }
        if (name.equals(PdfName.DCTDecode) || name.equals(PdfName.DCT)) {
            throw new NotImplementedException("DCTDecode");
        }
        if (name.equals(PdfName.JPXDecode)) {
            throw new NotImplementedException("JPXDecode");
        }
        if (name.equals(PdfName.Crypt)) {
            throw new NotImplementedException("Crypt");
        }
        return null;
    }

    protected Filter() {
    }

    public abstract byte[] decode(byte[] var1, int var2, int var3, PdfDictionary var4);

    public abstract byte[] encode(byte[] var1, int var2, int var3, PdfDictionary var4);
}

