/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.bytes.filters;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.bytes.filters.Filter;
import org.pdfclown.objects.PdfDictionary;

@PDF(value=VersionEnum.PDF10)
public final class ASCII85Filter
extends Filter {
    private static final String PrefixMark = "<~";
    private static final String SuffixMark = "~>";
    private static final boolean EnforceMarks = true;
    private static final int LineLength = 75;
    private static final int AsciiOffset = 33;
    private static final int[] Pow85 = new int[]{52200625, 614125, 7225, 85, 1};
    private static final String Encoding = "US-ASCII";

    private static void appendChar(StringBuilder buffer, char data, Params params) {
        buffer.append(data);
        ++params.linePos;
        if (params.linePos >= 75) {
            params.linePos = 0;
            buffer.append('\n');
        }
    }

    private static void appendString(StringBuilder buffer, String data, Params params) {
        if (params.linePos + data.length() > 75) {
            params.linePos = 0;
            buffer.append('\n');
        } else {
            params.linePos += data.length();
        }
        buffer.append(data);
    }

    private static void decodeBlock(byte[] decodedBlock, Params params) {
        ASCII85Filter.decodeBlock(decodedBlock, decodedBlock.length, params);
    }

    private static void decodeBlock(byte[] decodedBlock, int count, Params params) {
        int i = 0;
        while (i < count) {
            decodedBlock[i] = (byte)(params.tuple >> 24 - i * 8);
            ++i;
        }
    }

    private static void encodeBlock(byte[] encodedBlock, StringBuilder buffer, Params params) {
        ASCII85Filter.encodeBlock(encodedBlock, encodedBlock.length, buffer, params);
    }

    private static void encodeBlock(byte[] encodedBlock, int count, StringBuilder buffer, Params params) {
        int i = encodedBlock.length - 1;
        while (i >= 0) {
            encodedBlock[i] = (byte)(params.tuple % 85 + 33);
            params.tuple /= 85;
            --i;
        }
        i = 0;
        while (i < count) {
            ASCII85Filter.appendChar(buffer, (char)encodedBlock[i], params);
            ++i;
        }
    }

    ASCII85Filter() {
    }

    @Override
    public byte[] decode(byte[] data, int offset, int length, PdfDictionary parameters) {
        String dataString;
        byte[] decodedBlock = new byte[4];
        byte[] encodedBlock = new byte[5];
        Params params = new Params();
        try {
            dataString = new String(data, Encoding).trim();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (dataString.startsWith(PrefixMark)) {
            dataString = dataString.substring(PrefixMark.length());
        }
        if (dataString.endsWith(SuffixMark)) {
            dataString = dataString.substring(0, dataString.length() - SuffixMark.length());
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        int count = 0;
        boolean processChar = false;
        char[] cArray = dataString.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char dataChar = cArray[n2];
            switch (dataChar) {
                case 'z': {
                    if (count != 0) {
                        throw new RuntimeException("The character 'z' is invalid inside an ASCII85 block.");
                    }
                    decodedBlock[0] = 0;
                    decodedBlock[1] = 0;
                    decodedBlock[2] = 0;
                    decodedBlock[3] = 0;
                    stream.write(decodedBlock, 0, decodedBlock.length);
                    processChar = false;
                    break;
                }
                case '\u0000': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': {
                    processChar = false;
                    break;
                }
                default: {
                    if (dataChar < '!' || dataChar > 'u') {
                        throw new RuntimeException("Bad character '" + dataChar + "' found. ASCII85 only allows characters '!' to 'u'.");
                    }
                    processChar = true;
                }
            }
            if (processChar) {
                params.tuple += (dataChar - 33) * Pow85[count];
                if (++count == encodedBlock.length) {
                    ASCII85Filter.decodeBlock(decodedBlock, params);
                    stream.write(decodedBlock, 0, decodedBlock.length);
                    params.tuple = 0;
                    count = 0;
                }
            }
            ++n2;
        }
        if (count != 0) {
            if (count == 1) {
                throw new RuntimeException("The last block of ASCII85 data cannot be a single byte.");
            }
            params.tuple += Pow85[--count];
            ASCII85Filter.decodeBlock(decodedBlock, count, params);
            int i = 0;
            while (i < count) {
                stream.write(decodedBlock[i]);
                ++i;
            }
        }
        return stream.toByteArray();
    }

    @Override
    public byte[] encode(byte[] data, int offset, int length, PdfDictionary parameters) {
        byte[] decodedBlock = new byte[4];
        byte[] encodedBlock = new byte[5];
        Params params = new Params();
        StringBuilder buffer = new StringBuilder(data.length * (encodedBlock.length / decodedBlock.length));
        ASCII85Filter.appendString(buffer, PrefixMark, params);
        int count = 0;
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte dataByte = byArray[n2];
            if (count >= decodedBlock.length - 1) {
                params.tuple |= dataByte;
                if (params.tuple == 0) {
                    ASCII85Filter.appendChar(buffer, 'z', params);
                } else {
                    ASCII85Filter.encodeBlock(encodedBlock, buffer, params);
                }
                params.tuple = 0;
                count = 0;
            } else {
                params.tuple |= dataByte << 24 - count * 8;
                ++count;
            }
            ++n2;
        }
        if (count > 0) {
            ASCII85Filter.encodeBlock(encodedBlock, count + 1, buffer, params);
        }
        ASCII85Filter.appendString(buffer, SuffixMark, params);
        try {
            return buffer.toString().getBytes(Encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class Params {
        int linePos;
        int tuple = 0;

        private Params() {
        }
    }
}

