/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.bytes;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import org.pdfclown.bytes.IInputStream;
import org.pdfclown.tokens.Encoding;
import org.pdfclown.util.ConvertUtils;

public final class FileInputStream
implements IInputStream {
    private RandomAccessFile file;

    public FileInputStream(RandomAccessFile file) {
        this.file = file;
    }

    @Override
    public ByteOrder getByteOrder() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public long getPosition() {
        try {
            return this.file.getFilePointer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    public void read(byte[] data) throws EOFException {
        try {
            this.file.readFully(data);
        }
        catch (EOFException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void read(byte[] data, int offset, int length) throws EOFException {
        try {
            this.file.readFully(data, offset, length);
        }
        catch (EOFException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte readByte() throws EOFException {
        try {
            return this.file.readByte();
        }
        catch (EOFException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int readInt() throws EOFException {
        try {
            return this.file.readInt();
        }
        catch (EOFException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int readInt(int length) throws EOFException {
        byte[] data = new byte[length];
        try {
            this.file.readFully(data, 0, length);
        }
        catch (EOFException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ConvertUtils.byteArrayToNumber(data, 0, length, this.getByteOrder());
    }

    @Override
    public String readLine() throws EOFException {
        try {
            return this.file.readLine();
        }
        catch (EOFException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public short readShort() throws EOFException {
        try {
            return this.file.readShort();
        }
        catch (EOFException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String readString(int length) throws EOFException {
        byte[] data = new byte[length];
        try {
            this.file.readFully(data);
            return Encoding.Pdf.decode(data, 0, length);
        }
        catch (EOFException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int readUnsignedByte() throws EOFException {
        try {
            return this.file.readUnsignedByte();
        }
        catch (EOFException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int readUnsignedShort() throws EOFException {
        try {
            return this.file.readUnsignedShort();
        }
        catch (EOFException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void seek(long offset) {
        try {
            this.file.seek(offset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setByteOrder(ByteOrder value) {
    }

    @Override
    public void setPosition(long value) {
        try {
            this.file.seek(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void skip(long offset) {
        try {
            this.file.seek(this.file.getFilePointer() + offset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] toByteArray() {
        byte[] data = null;
        try {
            this.file.seek(0L);
            data = new byte[(int)this.file.length()];
            this.file.readFully(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return data;
    }

    @Override
    public long getLength() {
        try {
            return this.file.length();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
            this.file = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

