/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.bytes;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.pdfclown.bytes.IBuffer;
import org.pdfclown.bytes.IInputStream;
import org.pdfclown.bytes.IOutputStream;
import org.pdfclown.bytes.filters.Filter;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.tokens.Encoding;
import org.pdfclown.util.ConvertUtils;

public final class Buffer
implements IBuffer {
    private static final int DefaultCapacity = 256;
    private byte[] data;
    private int length;
    private int position = 0;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private boolean dirty;
    private List<IBuffer.IListener> listeners;

    public Buffer() {
        this(0);
    }

    public Buffer(int capacity) {
        if (capacity < 1) {
            capacity = 256;
        }
        this.data = new byte[capacity];
        this.length = 0;
    }

    public Buffer(BufferedReader dataStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int bufferLength;
            char[] buffer = new char[8192];
            while ((bufferLength = dataStream.read(buffer, 0, buffer.length)) != -1) {
                int i = 0;
                while (i < bufferLength) {
                    outputStream.write((byte)buffer[i]);
                    ++i;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.data = outputStream.toByteArray();
        this.length = this.data.length;
    }

    public Buffer(InputStream dataStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int bufferLength;
            byte[] buffer = new byte[8192];
            while ((bufferLength = dataStream.read(buffer, 0, buffer.length)) != -1) {
                outputStream.write(buffer, 0, bufferLength);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.data = outputStream.toByteArray();
        this.length = this.data.length;
    }

    public Buffer(byte[] data) {
        this.data = data;
        this.length = data.length;
    }

    public Buffer(byte[] data, ByteOrder byteOrder) {
        this.data = data;
        this.length = data.length;
        this.byteOrder = byteOrder;
    }

    @Override
    public void addListener(IBuffer.IListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IBuffer.IListener>();
        }
        this.listeners.add(listener);
    }

    @Override
    public IBuffer append(byte data) {
        this.ensureCapacity(1);
        this.data[this.length++] = data;
        this.notifyChange();
        return this;
    }

    @Override
    public IBuffer append(byte[] data) {
        return this.append(data, 0, data.length);
    }

    @Override
    public IBuffer append(byte[] data, int offset, int length) {
        this.ensureCapacity(length);
        System.arraycopy(data, offset, this.data, this.length, length);
        this.length += length;
        this.notifyChange();
        return this;
    }

    @Override
    public IBuffer append(String data) {
        return this.append(Encoding.Pdf.encode(data));
    }

    @Override
    public IBuffer append(IInputStream data) {
        return this.append(data.toByteArray(), 0, (int)data.getLength());
    }

    @Override
    public Buffer clone() {
        Buffer clone = new Buffer(this.getCapacity());
        clone.append(this.data);
        return clone;
    }

    @Override
    public void decode(Filter filter, PdfDictionary parameters) {
        this.data = filter.decode(this.data, 0, this.length, parameters);
        this.length = this.data.length;
    }

    @Override
    public void delete(int index, int length) {
        System.arraycopy(this.data, index + length, this.data, index, this.length - (index + length));
        this.length -= length;
        this.notifyChange();
    }

    @Override
    public byte[] encode(Filter filter, PdfDictionary parameters) {
        return filter.encode(this.data, 0, this.length, parameters);
    }

    @Override
    public int getByte(int index) {
        return this.data[index];
    }

    @Override
    public byte[] getByteArray(int index, int length) {
        byte[] data = new byte[length];
        System.arraycopy(this.data, index, data, 0, length);
        return data;
    }

    @Override
    public String getString(int index, int length) {
        return Encoding.Pdf.decode(this.data, index, length);
    }

    @Override
    public int getCapacity() {
        return this.data.length;
    }

    @Override
    public void insert(int index, byte[] data) {
        this.insert(index, data, 0, data.length);
    }

    @Override
    public void insert(int index, byte[] data, int offset, int length) {
        this.ensureCapacity(length);
        System.arraycopy(this.data, index, this.data, index + length, this.length - index);
        System.arraycopy(data, offset, this.data, index, length);
        this.length += length;
        this.notifyChange();
    }

    @Override
    public void insert(int index, String data) {
        this.insert(index, Encoding.Pdf.encode(data));
    }

    @Override
    public void insert(int index, IInputStream data) {
        this.insert(index, data.toByteArray());
    }

    @Override
    public boolean removeListener(IBuffer.IListener listener) {
        if (this.listeners == null) {
            return false;
        }
        return this.listeners.remove(listener);
    }

    @Override
    public void replace(int index, byte[] data) {
        System.arraycopy(data, 0, this.data, index, data.length);
        this.notifyChange();
    }

    @Override
    public void replace(int index, byte[] data, int offset, int length) {
        System.arraycopy(data, offset, this.data, index, data.length);
        this.notifyChange();
    }

    @Override
    public void replace(int index, String data) {
        this.replace(index, Encoding.Pdf.encode(data));
    }

    @Override
    public void replace(int index, IInputStream data) {
        this.replace(index, data.toByteArray());
    }

    @Override
    public void setDirty(boolean value) {
        this.dirty = value;
    }

    @Override
    public void setLength(int value) {
        this.length = value;
        this.notifyChange();
    }

    @Override
    public void writeTo(IOutputStream stream) {
        stream.write(this.data, 0, this.length);
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void read(byte[] data) {
        this.read(data, 0, data.length);
    }

    @Override
    public void read(byte[] data, int offset, int length) {
        System.arraycopy(this.data, this.position, data, offset, length);
        this.position += length;
    }

    @Override
    public byte readByte() throws EOFException {
        if (this.position >= this.data.length) {
            throw new EOFException();
        }
        return this.data[this.position++];
    }

    @Override
    public int readInt() throws EOFException {
        int value = ConvertUtils.byteArrayToInt(this.data, this.position, this.byteOrder);
        this.position += 4;
        return value;
    }

    @Override
    public int readInt(int length) throws EOFException {
        int value = ConvertUtils.byteArrayToNumber(this.data, this.position, length, this.byteOrder);
        this.position += length;
        return value;
    }

    @Override
    public String readLine() throws EOFException {
        if (this.position >= this.data.length) {
            throw new EOFException();
        }
        StringBuilder buffer = new StringBuilder();
        while (this.position < this.data.length) {
            byte c;
            if ((c = this.data[this.position++]) == 13 || c == 10) break;
            buffer.append((char)c);
        }
        return buffer.toString();
    }

    @Override
    public short readShort() throws EOFException {
        short value = (short)ConvertUtils.byteArrayToNumber(this.data, this.position, 2, this.byteOrder);
        this.position += 2;
        return value;
    }

    @Override
    public String readString(int length) {
        String data = Encoding.Pdf.decode(this.data, this.position, length);
        this.position += length;
        return data;
    }

    @Override
    public int readUnsignedByte() throws EOFException {
        if (this.position >= this.data.length) {
            throw new EOFException();
        }
        return this.data[this.position++] & 0xFF;
    }

    @Override
    public int readUnsignedShort() throws EOFException {
        try {
            if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                return this.data[this.position++] & 0xFF | (this.data[this.position++] & 0xFF) << 8;
            }
            return (this.data[this.position++] & 0xFF) << 8 | this.data[this.position++] & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EOFException();
        }
    }

    @Override
    public void seek(long position) {
        this.setPosition(position);
    }

    @Override
    public void setByteOrder(ByteOrder value) {
        this.byteOrder = value;
    }

    @Override
    public void setPosition(long value) {
        if (value < 0L) {
            value = 0L;
        } else if (value > (long)this.data.length) {
            value = this.data.length;
        }
        this.position = (int)value;
    }

    @Override
    public void skip(long offset) {
        this.setPosition((long)this.position + offset);
    }

    @Override
    public byte[] toByteArray() {
        byte[] data = new byte[this.length];
        System.arraycopy(this.data, 0, data, 0, this.length);
        return data;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void write(byte[] data) {
        this.append(data);
    }

    @Override
    public void write(byte[] data, int offset, int length) {
        this.append(data, offset, length);
    }

    @Override
    public void write(String data) {
        this.append(data);
    }

    @Override
    public void write(IInputStream data) {
        this.append(data);
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private void ensureCapacity(int additionalLength) {
        int minCapacity = this.length + additionalLength;
        if (minCapacity <= this.data.length) {
            return;
        }
        byte[] data = new byte[Math.max(this.data.length << 1, minCapacity)];
        System.arraycopy(this.data, 0, data, 0, this.length);
        this.data = data;
    }

    private void notifyChange() {
        if (this.dirty || this.listeners == null) {
            return;
        }
        this.dirty = true;
        for (IBuffer.IListener listener : this.listeners) {
            listener.onChange(this);
        }
    }
}

