/*
 * Decompiled with CFR 0.152.
 */
package highlight;

import highlight.BlockLayout;
import highlight.FileDrop;
import highlight.PDFHighlight;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;

public class PDFHighlightApp
implements ActionListener {
    Properties properties = new Properties();
    JButton hlButton = null;
    String pdfFilePath = "";
    String filePathText = "";
    final JTextArea hlTextArea = new JTextArea();
    final JTextPane matchesTextArea = new JTextPane();
    final JTextArea filePathTextArea = new JTextArea();

    public void go() {
        Font font = new Font("Arial", 0, 16);
        Font fontBold = new Font("Arial", 1, 16);
        this.filePathText = "\n\n          drop pdf file here ...";
        this.loadProperties();
        JFrame frame = new JFrame("PDF Highlight");
        this.filePathTextArea.setBackground(Color.ORANGE);
        this.filePathTextArea.setFont(fontBold);
        this.filePathTextArea.setText(this.filePathText);
        this.matchesTextArea.setContentType("text/html");
        this.matchesTextArea.setText("<html><font face=\"Arial\" style=\"font-size:16pt;\"><b> Usage: Highlight terms in pdf files</b><ul><li style='padding:4pt;'><b>This tool only works with searchable mixed-mode (dual-layer) PDFs which are ocred using image-mode PDF input files.</b></li><li style='padding:4pt;'>Drag&drop a pdf file to the left upper corner.</li><li style='padding:4pt;'>Enter expressions to be highlighted (synonyms separated by a blank (eg 'pipe tube'), for compound words use '_', eg heat_pump).</li><li style='padding:4pt;'>Terms are automatically left and right truncated.</li><li style='padding:4pt;'>Distinct colours are used per line of terms of the left 'Enter Highlight Terms' window.</li><li style='padding:4pt;'>After hitting 'Highlight' the pdf document will be opened with the page having the first match. A copy of the pdf containing the highlights is saved having the extension '.hl.pdf'.</li></ul></font><html>");
        JPanel hlPanel = new JPanel();
        BlockLayout layout = new BlockLayout();
        layout.setAlign(1);
        layout.setPadding(2, 4, 4, 4);
        hlPanel.setLayout(layout);
        JLabel topLabel = new JLabel("Enter Highlight Terms");
        topLabel.setFont(fontBold);
        this.hlTextArea.setEditable(true);
        this.hlTextArea.setFont(font);
        this.hlTextArea.setColumns(28);
        this.hlTextArea.setRows(24);
        hlPanel.add(topLabel);
        hlPanel.add(this.hlTextArea);
        JSplitPane splitPaneInner = new JSplitPane(0, this.filePathTextArea, hlPanel);
        splitPaneInner.setDividerLocation(100);
        this.hlButton = new JButton("Highlight");
        this.hlButton.setMnemonic(72);
        this.hlButton.setActionCommand("enable");
        this.hlButton.setEnabled(true);
        this.hlButton.addActionListener(this);
        JSplitPane splitPaneOuter = new JSplitPane(0, splitPaneInner, this.hlButton);
        splitPaneOuter.setDividerLocation(500);
        JSplitPane splitPaneHorizontal = new JSplitPane(1, splitPaneOuter, this.matchesTextArea);
        splitPaneHorizontal.setDividerLocation(300);
        frame.getContentPane().add(splitPaneHorizontal);
        new FileDrop(null, this.filePathTextArea, new FileDrop.Listener(){

            @Override
            public void filesDropped(File[] files) {
                PDFHighlightApp.this.filePathTextArea.setText("");
                int i = 0;
                if (i < files.length) {
                    PDFHighlightApp.this.filePathTextArea.append("\n  " + files[i].getName() + "\n\n  (drop new pdf file here)");
                    try {
                        PDFHighlightApp.this.pdfFilePath = files[i].getCanonicalPath();
                        PDFHighlightApp.this.saveProperties();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        frame.setBounds(100, 100, 800, 600);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.saveProperties();
        if (e.getSource().equals(this.hlButton)) {
            PDFHighlight ph = new PDFHighlight();
            String[] lines = this.hlTextArea.getText().trim().replaceAll(" +", " ").replaceAll("\n+", "\n").split("\n");
            String[] args = new String[lines.length + 1];
            args[0] = this.pdfFilePath.trim();
            int i = 0;
            while (i < lines.length) {
                args[i + 1] = lines[i].trim().replaceAll(" ", "|");
                ++i;
            }
            Runtime p = Runtime.getRuntime();
            try {
                p.exec("wscript.exe terminate_reader.vbs");
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
            ArrayList<String> resultList = ph.process(args);
            this.matchesTextArea.setText(resultList.get(1));
            String pageToOpen = resultList.get(0);
            try {
                p.exec("wscript.exe open_reader.vbs \"" + this.pdfFilePath.trim().replaceAll("pdf$", "hl.pdf") + "\" " + pageToOpen);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void loadProperties() {
        try {
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream("pdfhl.properties"));
            this.properties.load(stream);
            stream.close();
            this.pdfFilePath = this.properties.getProperty("pdfFilePath");
            File file = new File(this.pdfFilePath);
            if (file.exists()) {
                this.filePathText = "\n  " + file.getName() + "\n\n  (drop new pdf file here)";
            }
            this.pdfFilePath = file.getAbsolutePath();
            this.hlTextArea.setText(this.properties.getProperty("hlTextArea"));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveProperties() {
        try {
            Properties props = new Properties();
            props.setProperty("pdfFilePath", this.pdfFilePath);
            props.setProperty("hlTextArea", this.hlTextArea.getText());
            File f = new File("pdfhl.properties");
            FileOutputStream out = new FileOutputStream(f);
            props.store(out, "pdfhl properties file");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        PDFHighlightApp ph = new PDFHighlightApp();
        ph.go();
    }
}

