/*
 * Decompiled with CFR 0.152.
 */
package highlight;

import highlight.TextMarkupNew;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.Page;
import org.pdfclown.documents.contents.ITextString;
import org.pdfclown.documents.contents.colorSpaces.DeviceRGBColor;
import org.pdfclown.documents.interaction.viewer.ViewerPreferences;
import org.pdfclown.documents.interchange.metadata.Information;
import org.pdfclown.files.SerializationModeEnum;
import org.pdfclown.tools.TextExtractor;
import org.pdfclown.util.math.geom.Quad;

public class PDFHighlight {
    ArrayList<DeviceRGBColor> colorList = new ArrayList();
    org.pdfclown.files.File file;

    PDFHighlight() {
        this.colorList.add(new DeviceRGBColor(1.0, 0.0, 0.75));
        this.colorList.add(new DeviceRGBColor(1.0, 0.75, 0.0));
        this.colorList.add(new DeviceRGBColor(1.0, 1.0, 0.0));
        this.colorList.add(new DeviceRGBColor(0.0, 0.8, 0.8));
        this.colorList.add(new DeviceRGBColor(0.0, 0.5, 0.9));
        this.colorList.add(new DeviceRGBColor(0.1, 1.0, 0.1));
        this.colorList.add(new DeviceRGBColor(1.0, 0.1, 0.1));
    }

    public static void main(String[] args) {
        new PDFHighlight().process(args);
    }

    public ArrayList<String> process(String[] args) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><font face=\"Arial\" style=\"font-size:16pt;\"><b>Found matches</b><ul>");
        int firstPageWithMatch = 0;
        if (args.length > 1) {
            String filePath = args[0];
            try {
                this.file = new org.pdfclown.files.File(filePath);
            }
            catch (Exception e) {
                throw new RuntimeException(String.valueOf(filePath) + " file access error.", e);
            }
            ArrayList<String> terms = new ArrayList<String>();
            int i = 1;
            while (i < args.length) {
                terms.add(args[i]);
                ++i;
            }
            TextExtractor textExtractor = new TextExtractor(false, false);
            ArrayList<Quad> highlightQuads = null;
            int currentPage = 0;
            HashMap matchedPages = new HashMap();
            for (Page page : this.file.getDocument().getPages()) {
                this.pln("page=" + ++currentPage);
                highlightQuads = new ArrayList<Quad>();
                List<ITextString> pageTextStrings = textExtractor.extract(page).get(null);
                StringBuilder pageText = new StringBuilder();
                ArrayList<Integer> textPositionIndex = new ArrayList<Integer>();
                int j = 0;
                while (j < pageTextStrings.size()) {
                    String expression = pageTextStrings.get(j).getText();
                    ITextString textString = pageTextStrings.get(j);
                    double y = textString.getBox().getY();
                    String space = " ";
                    if (j < pageTextStrings.size() - 1 && expression.endsWith("-") && pageTextStrings.get(j + 1).getBox().getY() > y + 5.0) {
                        expression = expression.replaceAll("-$", "");
                        space = "";
                    }
                    pageText.append(String.valueOf(expression) + space);
                    int k = 0;
                    while (k < expression.length() + space.length()) {
                        textPositionIndex.add(j);
                        ++k;
                    }
                    ++j;
                }
                int i2 = 0;
                for (String term : terms) {
                    if (!matchedPages.containsKey(term)) {
                        matchedPages.put(term, new ArrayList());
                    }
                    String termToSearch = term.replaceAll("_", "[\\\\w\u00df\u00e4\u00f6\u00fc]*[ _-]");
                    DeviceRGBColor color = this.colorList.get(++i2 % this.colorList.size());
                    this.pln("highlight term=" + termToSearch);
                    String regularExpression = "(?i)\\b[\\w\u00df\u00e4\u00f6\u00fc]*" + termToSearch + "[\\w\u00df\u00e4\u00f6\u00fc]*\\b";
                    Pattern highlightPattern = Pattern.compile(regularExpression);
                    Matcher matcher = highlightPattern.matcher(pageText.toString());
                    while (matcher.find()) {
                        this.pln("found=" + matcher.group());
                        if (firstPageWithMatch == 0) {
                            firstPageWithMatch = currentPage;
                        }
                        if (!((ArrayList)matchedPages.get(term)).contains(currentPage)) {
                            ((ArrayList)matchedPages.get(term)).add(currentPage);
                        }
                        int start = matcher.start();
                        int end = matcher.end();
                        int index = -1;
                        int prevIndex = -1;
                        int r = start;
                        while (r < end) {
                            index = (Integer)textPositionIndex.get(r);
                            if (index != prevIndex) {
                                ITextString textString = pageTextStrings.get(index);
                                Rectangle2D textStringBox = textString.getBox();
                                int length = textString.getText().length();
                                if (Math.round(textStringBox.getWidth()) == 0L) {
                                    textStringBox.setRect(textStringBox.getX(), textStringBox.getY() - textStringBox.getHeight() * 0.5, textStringBox.getHeight() * 0.95 * (double)length, textStringBox.getHeight() * 2.0);
                                }
                                highlightQuads.add(Quad.get(textStringBox));
                            }
                            prevIndex = index;
                            ++r;
                        }
                    }
                    this.pln("quad size=" + highlightQuads.size());
                    if (highlightQuads.size() > 0) {
                        new TextMarkupNew(page, null, TextMarkupNew.MarkupTypeEnum.Highlight, highlightQuads, color);
                    }
                    highlightQuads.clear();
                }
            }
            this.pln("first match on page=" + firstPageWithMatch);
            this.pln("matched pages per term:");
            for (String t : matchedPages.keySet()) {
                ArrayList matchedPagesIntervall = new ArrayList();
                int k = 0;
                while (k < ((ArrayList)matchedPages.get(t)).size()) {
                    if (k == 0) {
                        ArrayList<Integer> intervall = new ArrayList<Integer>();
                        intervall.add((Integer)((ArrayList)matchedPages.get(t)).get(k));
                        intervall.add((Integer)((ArrayList)matchedPages.get(t)).get(k));
                        matchedPagesIntervall.add(intervall);
                    } else {
                        int z = (Integer)((ArrayList)matchedPagesIntervall.get(matchedPagesIntervall.size() - 1)).get(1);
                        if ((Integer)((ArrayList)matchedPages.get(t)).get(k) == 1 + z) {
                            ((ArrayList)matchedPagesIntervall.get(matchedPagesIntervall.size() - 1)).set(1, z + 1);
                        } else {
                            ArrayList<Integer> intervall = new ArrayList<Integer>();
                            intervall.add((Integer)((ArrayList)matchedPages.get(t)).get(k));
                            intervall.add((Integer)((ArrayList)matchedPages.get(t)).get(k));
                            matchedPagesIntervall.add(intervall);
                        }
                    }
                    ++k;
                }
                String result = "";
                String sep = ", ";
                int k2 = 0;
                while (k2 < matchedPagesIntervall.size()) {
                    int a1;
                    int a0 = (Integer)((ArrayList)matchedPagesIntervall.get(k2)).get(0);
                    result = a0 == (a1 = ((Integer)((ArrayList)matchedPagesIntervall.get(k2)).get(1)).intValue()) ? String.valueOf(result) + a0 + sep : String.valueOf(result) + a0 + " - " + a1 + sep;
                    if (sep.equals("")) {
                        sep = ", ";
                    }
                    ++k2;
                }
                result = result.replaceAll(",.?$", "");
                this.pln(String.valueOf(t) + ": " + result);
                sb.append("<li>\"" + t + "\":<br/>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp pages = " + result + "<br/>&nbsp</li>");
            }
            sb.append("</ul></font><html>");
            this.serialize(this.file, "new", null, "", "", "");
        }
        ArrayList<String> returnList = new ArrayList<String>();
        if (firstPageWithMatch == 0) {
            firstPageWithMatch = 1;
        }
        returnList.add(String.valueOf(firstPageWithMatch));
        returnList.add(sb.toString());
        return returnList;
    }

    public void pln(String text) {
        System.out.println(text);
    }

    protected String serialize(org.pdfclown.files.File file, String fileName, SerializationModeEnum serializationMode, String title, String subject, String keywords) {
        this.applyDocumentSettings(file.getDocument(), title, subject, keywords);
        System.out.println();
        if (serializationMode == null) {
            serializationMode = file.getReader() == null ? SerializationModeEnum.Standard : SerializationModeEnum.Incremental;
        }
        String f = file.getPath().replaceAll("pdf$", "hl.pdf");
        File outputFile = new File(f);
        try {
            file.save(outputFile, serializationMode);
        }
        catch (Exception e) {
            this.pln("File writing failed: " + e.getMessage());
            e.printStackTrace();
        }
        this.pln("\nOutput: " + outputFile.getPath());
        return outputFile.getPath();
    }

    private void applyDocumentSettings(Document document, String title, String subject, String keywords) {
        if (title == null) {
            return;
        }
        ViewerPreferences view = new ViewerPreferences(document);
        document.setViewerPreferences(view);
        view.setDisplayDocTitle(true);
        Information info = document.getInformation();
        info.clear();
        info.setCreationDate(new Date());
        info.setCreator(this.getClass().getName());
        info.setKeywords(keywords);
    }
}

